// Excel2Dlg.cpp : implementation file
//

#include "stdafx.h"
#include "Excel2.h"
#include "Excel2Dlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CExcel2Dlg dialog

LPDISPATCH CExcel2Dlg::GetIDispatch(CString AppName)
{
    CLSID clsid;
    CLSIDFromProgID(AppName, &clsid);
    
    IUnknown *pUnk;
    HRESULT hr = GetActiveObject(clsid, NULL, (IUnknown**)&pUnk);
    ASSERT(!FAILED(hr));
    
    IDispatch *pDisp;
    hr = pUnk->QueryInterface(IID_IDispatch, (void **)&pDisp);
    ASSERT(!FAILED(hr));

    // Zwolnienie niepotrzebnego ju interfejsu IUnknown
    pUnk->Release();
    
    return pDisp;
}

CExcel2Dlg::CExcel2Dlg(CWnd* pParent /*=NULL*/)
	: CDialog(CExcel2Dlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	::CoInitializeEx(NULL, 0);
}

void CExcel2Dlg::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    DDX_Control(pDX, IDC_EDIT1, Edit1);
    DDX_Control(pDX, IDC_STATIC1, Label1);
}

BEGIN_MESSAGE_MAP(CExcel2Dlg, CDialog)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
    ON_BN_CLICKED(IDC_BUTTON1, &CExcel2Dlg::OnBnClickedButton1)
    ON_BN_CLICKED(IDC_BUTTON2, &CExcel2Dlg::OnBnClickedButton2)
    ON_BN_CLICKED(IDC_BUTTON3, &CExcel2Dlg::OnBnClickedButton3)
END_MESSAGE_MAP()


// CExcel2Dlg message handlers

BOOL CExcel2Dlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here

	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CExcel2Dlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CExcel2Dlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}


void CExcel2Dlg::OnBnClickedButton1()
{
    CRange oRange;
    CString adres, wartosc;
    LPDISPATCH pDisp = GetIDispatch(L"Excel.Application");
    
    oExcel.AttachDispatch(pDisp);
    oRange = oExcel.get_ActiveCell();
    wartosc = oRange.get_Value2();
    adres = oRange.get_Address(COleVariant((short)TRUE), 
        COleVariant((short)TRUE), 1, COleVariant((short)TRUE),
        COleVariant((short)FALSE));
    
    Label1.SetWindowTextW(adres);
    Edit1.SetWindowTextW(wartosc);
    
    oExcel.ReleaseDispatch();
}


void CExcel2Dlg::OnBnClickedButton2()
{
    CRange oRange;
    CString wartosc;
    LPDISPATCH pDisp = GetIDispatch(L"Excel.Application");                
    
    oExcel.AttachDispatch(pDisp);
    oRange = oExcel.get_ActiveCell();

    Edit1.GetWindowTextW(wartosc);
    oRange.put_Value2(COleVariant(wartosc));
    
    oExcel.ReleaseDispatch();
}

void CExcel2Dlg::OnBnClickedButton3()
{
    CRange oRange;
    CFont0 font;
    LPDISPATCH pDisp = GetIDispatch(L"Excel.Application");
    
    oExcel.AttachDispatch(pDisp);
    oRange = oExcel.get_ActiveCell();
    font = oRange.get_Font();
    font.put_Bold(COleVariant((short)1));     
    
    oExcel.ReleaseDispatch();
}
